<?php
require '../../../vendor/autoload.php';
use Aws\Route53\Route53Client;
use Aws\Route53\Exception\Route53Exception;
try {
    
	ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);

    
$client= Route53Client::factory([
    'region'   => 'us-west-2',
    'version'  => 'latest',
    // 'debug'  => true,
    'credentials' => array(
        'key'    => $_REQUEST['auth_data']['aws_access_key_id'],
        'secret' => $_REQUEST['auth_data']['aws_secret_access_key'],
    )
]);
if(isset($_REQUEST['all_zones']) and $_REQUEST['all_zones']==1){
    $result = $client->listHostedZones();
    echo json_encode(['success'=>true,'data'=>$result['HostedZones']]);
    exit;
}
if(isset($_REQUEST['zone_by_name']) and $_REQUEST['zone_by_name']==1){
        $result = $client->listHostedZonesByName([
        'DNSName' => $_REQUEST['domain']
    ]);
    if(!empty($result['HostedZones'])){
        foreach($result['HostedZones'] as $zone){
            $result = $client->listResourceRecordSets([
            'HostedZoneId' => $zone['Id']
              ]);
             
              if(is_array($result['ResourceRecordSets'])){
                  // Deleting Record
                foreach($result['ResourceRecordSets'] as $record){
                    if($record['Type']==$_REQUEST['type']){
                        $result = $client->changeResourceRecordSets([
                            'ChangeBatch' => [
                                'Changes' => [
                                    [
                                        'Action' => 'DELETE',
                                        'ResourceRecordSet' => $record
                                    ],
                                ],
                                'Comment' => '',
                            ],
                            'HostedZoneId' => $zone['Id'],
                        ]);  
                    }
                        
                    }
              }
              $value=$_REQUEST['value'];
              if(strlen($value) > 255 ){
                $string = '';
                $parts = str_split($value, 255);
                    foreach($parts as $part){
                       $string.='"'.$part.'"';
                    }
                $value=$string;
                }
                   // Creating Record
                  $result = $client->changeResourceRecordSets([
                        'ChangeBatch' => [
                            'Changes' => [
                                [
                                    'Action' => 'CREATE',
                                    'ResourceRecordSet' => [
                                        'Name' => $_REQUEST['host'].".".$_REQUEST['domain'],
                                        'ResourceRecords' => [
                                            [
                                                'Value' => $value,
                                            ],
                                        ],
                                        'TTL' => 60,
                                        'Type' => $_REQUEST['type'],
                                    ],
                                ],
                            ],
                            'Comment' => '',
                        ],
                        'HostedZoneId' => $zone['Id'],
                    ]);
              
   
           
        }
         echo json_encode(['success'=>true,'data'=>'Record have been added successfully']);
   
    }else{
         echo json_encode(['success'=>false,'data'=>'Zone dosn\'t exists']);
    }
   
   
}

	
} catch (Route53Exception $e) {
	   echo json_encode(['success'=>false,'data'=>$e->getAwsErrorMessage()]);
}
exit;

?>