<?php
use \Illuminate\Support\Facades\Route;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Route::group(['namespace' => 'Modules\DNS\Http\Controllers'], function () {
    Route::group(['middleware' => ['web', 'auth']], function () {
        Route::get('addons/dns/manage/providers', 'DNSController@manage_providers')->name('manage_providers');
        Route::get('addons/dns/modules/all', 'DNSController@dnsModules')->name('dnsModules');
        Route::get('addons/dns/module/create/{name}', 'DNSController@dnsModuleCreate')->name('dnsModuleCreate');
        Route::get('addons/dns/module/{id}/edit', 'DNSController@dnsModuleEdit')->name('dnsModuleEdit');
        Route::post('addons/dns/module', 'DNSController@dnsModuleAdd')->name('dnsModuleAdd');
        Route::put('addons/dns/module/{id}', 'DNSController@dnsModuleUpdate')->name('dnsModuleUpdate');
        Route::delete('addons/dns/module/delete/{id}', 'DNSController@dnsModuleDelete')->name('dnsModuleDelete');
        Route::post('addons/dns/module/get/toDelete', 'DNSController@getDnsToDelete')->name('getDnsToDelete');
        Route::post('addons/dns/module/update/status', 'DNSController@activateOrDeactivate')->name('activateOrDeactivate');
        Route::post('/attach/provider', 'DNSController@attachProvider')->name('attachProvider');
        Route::post('add/record', 'DNSController@addDsnRecord')->name('addDsnRecord');
        Route::post('fetch/zones', 'DNSController@fetchZones')->name('fetchZones');
        Route::post('dns/activateOrDeactivateProvider', 'DNSController@activateOrDeactivateProvider')->name('activateOrDeactivateProvider');

    });
//});
