@extends(decide_template())

@section('title', $pageTitle)

@section('page_styles')
<link href="{{ url('Addons/DNS/Resources/assets/css/registrars.css') }}" rel="stylesheet" type="text/css">
@endsection

@section('page_scripts')
<script type="text/javascript">
    $(document).ready(function() {
        $(".activate").click(function() {
            var active = $(this);
            $(".blockUI").show();
            setTimeout(function() {
                $(active).parent("td").addClass("active");
                Command: toastr["success"] ("The selected module activated successfully");
                $(".blockUI").hide();
            }, 1000);
        });
        $(".deactivate").click(function() {
            var deactive = $(this);
            $(".blockUI").show();
            setTimeout(function() {
                $(deactive).parent("td").removeClass("active");
                Command: toastr["success"] ("The selected module deactivated successfully");
                $(".blockUI").hide();
            }, 1000);
        });
    });
</script>
@endsection

@section(decide_content())

<div class="row">
    <div class="col-md-8 create-form">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="kt-portlet kt-portlet--height-fluid">
            <div class="kt-portlet__body">
                <table class="table table-striped table-checkable responsive" id="modules">
                	<thead>
                		<tr>
                			<th colspan="3">List of available DNS Providers</th>
                		</tr>
                	</thead>
                	<tbody>
                        @foreach($configs as $config)
                                               <tr>
                            <td width="200px">
                                <img src="{{substr($config[0]['config']['logo'],0,5) == 'http' ? $config[0]['config']['logo'] :url('Addons/DNS/Resources/assets/'.$config[0]['config']['logo'])}}" alt="{{$config[0]['config']['name']}}">
                            </td>
                            <td>{{$config[0]['config']['name']}} <span>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.</span></td>
                            <td class="" width="250px">
                                <button class="btn btn-success btn-sm activate">Activate</button>
                                <button class="btn btn-default btn-sm deactivate">Deactivate</button>
                            </td>
                        </tr>
                                            @endforeach
                                      
                		
                		
                	</tbody>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>

@endsection