<?php
namespace Addons\DNS\Modules;

/**
 * Class DNS Made Easy
 * @package Addons\DNS\Modules
 */
class DNS_made_easy
{
    /**
     *
     */
    static $sandbox_url    = 'https://api.sandbox.dnsmadeeasy.com/V2.0/';
    static $production_url = 'https://api.dnsmadeeasy.com/V2.0/';
    private $params         = [];
    /**
     * @return array
     */
    function DNS_made_easy_ConfigOptions()
    {
        $configArray = [
            'config'=>[
            "name" => "DNS Made Easy",
            "description" => "DNS Made Easy offers a REST based API free to all business and corporate memberships.",
            "logo" => "images/dnsmadeeasy.jpg",
            "help_url"=>"https://support.dnsmadeeasy.com/support/solutions/articles/47001131906-finding-or-generating-api-keys-in-dns-made-easy"
                ],
            'form' => [
                [
                    "label" => "Envoirnment",
                    "name" => "envoirnment",
                    "type" => "radio", # Type of the Field
                    "width" => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class" => "envoirnment", # Defines the Field class
                    "options" => ['Sandbox','Production'], # List Options
                    "description" =>  "Sandbox or Production",
                    "default" => "Sandbox"
                ],
                [
                    "label" => "API Key",
                    "name" => "api_key",
                    "type" => "text", # Type of the Field
                    "width" => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class" => "form-control", # Defines the Field class
                    "description" =>  "The value for API Key can be found on <b>theConfig - Account Information </b> page once logged into your DNS Made Easy account.",
                    "default" => ""
                ],
                 [
                    "label" => "Secret Key",
                    "name" => "secret_key",
                    "type" => "text", # Type of the Field
                    "width" => "", # Defines the Field Width in px,rem etc. Leave empty if you don't want
                    "class" => "form-control", # Defines the Field class
                    "description" =>  "The value for Secret Key can be found on <b>theConfig - Account Information </b> page once logged into your DNS Made Easy account. ",
                    "default" => ""
                ]
            ]
        ];
        return $configArray;
    }


    public function DNS_made_easy_Update($params)
    {

        $this->params=$params;
        $response = $this->apiCall('dns/managed'); // Fetching all zones
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        if(isset($data['error']))
            return ['success' => false ,'message' =>implode('\n', $data['error'])];
       
        $zone_id = '';
        foreach ($data['data'] as $key => $item) {
            if($item['name'] ==$params['domain']){
                $zone_id=$item['id'];
            }
        }

        if($zone_id == '')
           return ['success' => false,'message' => 'Zone dosn\'t exists'];

        $response = $this->apiCall("dns/managed/$zone_id/records"); // Fetching all zone records
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
         if(isset($data['error']))
            return ['success' => false ,'message' =>implode('\n', $data['error'])];
     
        if(!empty($data['data'])){
            foreach ($data['data'] as $record) {
            if($record['type']==$params['type'] && $record['name']==$params['host']){
                $record_id=$record['id'];
                  // Deleting zone record   
                  $response = $this->apiCall("dns/managed/$zone_id/records/$record_id",[],'DELETE'); // Deleting Record
                 
                if(isJson($response)){
                $data=json_decode($response,true);
                if(isset($data['error']))
                  return ['success' => false ,'message' =>implode('\n', $data['error'])];
                }
                  
                
            }
          }
        }
       
          // Creating a zone record 
        $data=[
            "name" => $params['host'],
            "type" => $params['type'],
            "value" => $params['value'],
            "gtdLocation" =>"DEFAULT",
            "ttl" => 86400
        ];
        $response = $this->apiCall("dns/managed/$zone_id/records",$data,'POST'); // Creating zone record
        
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        if(isset($data['message']))
            return ['success' => false ,'message' =>$data['message']];
         if(isset($data['error']))
            return ['success' => false ,'message' =>implode('\n', $data['error'])];

        return ['success' => true ,'message' =>'Record have been added successfully'];
   }
    
  

   private function apiCall ( $url,$data=[],$method="GET") {

        $api_key=$this->params['auth_data']['api_key'];
        $secret_key=$this->params['auth_data']['secret_key'];
        $envoirnment=$this->params['auth_data']['envoirnment'];

        // API access url based on envoirnment
        if($envoirnment=="Sandbox"){
           $api_url = self::$sandbox_url.$url;
        }else{
           $api_url = self::$production_url.$url;
        }
       
        // Create signing key
        $reqDateTime =gmdate('D, d M Y H:i:s T', time());
        $hmac = hash_hmac("SHA1", $reqDateTime, $secret_key);
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
          "x-dnsme-apiKey: $api_key",
          "x-dnsme-requestDate: $reqDateTime",
          "x-dnsme-hmac: $hmac",
        ]);

        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($ch, CURLOPT_URL,  $api_url);

          // Params to send with POST method
         if(!empty($data) && $method=="POST"){
            $body = json_encode($data);
            // set body
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
         }
         // Sending request
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    public function DNS_made_easy_FetchZones($params)
    {
       
        $this->params=$params;
        $response = $this->apiCall('dns/managed'); // Fetching all zones
        if(!isJson($response))
            return ['success' => false ,'message' =>$response];
        $data=json_decode($response,true);
        if(isset($data['error']))
            return ['success' => false ,'message' =>implode('\n', $data['error'])];
        $zones = [];
        foreach ($data['data'] as $key => $item) {
            $zones[]= $item['name'];
        }

        return ['success' => true ,'options' =>$zones];
    }

}