<?php
namespace Addons\DNS\Http\Controllers;

use Addons\DNS\Helper\Common;
use Addons\DNS\Entities\AddonDNS;
use Addons\DNS\Entities\DNSProviders;
use Addons\DNS\Entities\DNSProvidersAttached;
use App\DomainMasking;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;

class DNSController extends SubController
{
    private $dns;
    private $domain;
    private $dnsNamespace = 'Addons\DNS\Modules\\';

    public function __construct(AddonDNS $dns,DomainMasking $domain)
    {
        parent::__construct();
        $this->dns = $dns;
        $this->domain = $domain;
    }

    public function dnsModules()
    {
        $pageTitle =  trans('dns::app.index.pageTitle');
        $pageDescription = trans('dns::app.index.pageDesc');
        $breadCrum[] = array('title' => trans('app.lang_integration'), 'url' => "javascript:;");
        $breadCrum[] = array('title' => trans('app.lang_dns_providers'), 'url' => "");
        $modules_path = $this->modules_path;
        $files = File::allFiles($modules_path);
        $configs =[];
       foreach ($files as $file)
       {

           try {
               $fileName = $file->getFilename();
               $className = substr($fileName, 0, -4);
               $class = $this->modules_namespace . $className; 
               $provider  = DNSProviders::where('class',$className)->first();
               if (class_exists($class)) {
                   $object = new $class;
                   if (method_exists($object, $className . "_ConfigOptions") && (!$provider || $provider->status==1))
                        $configs[$className] = [$object->{$className . "_ConfigOptions"}(),$className,$provider];
               }
           }
           catch (\Exception $e)
           {

           }

       }
        $configs = array_reverse($configs);
        $addons = AddonDNS::select('addons_dns.*','p.status as active_status')
        ->where('user_id','=',auth()->user()->id)
        ->where(function($query){
            $query->where('p.status','=',1);
            $query->orWhere('p.status','=',null);
        })->leftJoin('addons_dns_providers_statuses as p','p.class','=','addons_dns.class_name')
        ->get();       
        return view('dns::index', compact('addons','pageTitle','pageDescription','breadCrum','configs'));
    }
    public function manage_providers()
    {
        $pageTitle =  trans('dns::app.providers.page.title');
        $pageDescription = trans('dns::app.providers.page.description');
        $breadCrum[] = array('title' => trans('app.lang_integration'), 'url' => "javascript:;");
        $breadCrum[] = array('title' => trans('app.lang_dns_providers'), 'url' => "");
        $modules_path = $this->modules_path;
        $files = File::allFiles($modules_path);
        $configs =[];
        
       foreach ($files as $file)
       {

           try {
               $fileName  = $file->getFilename();
               $className = substr($fileName, 0, -4);
               $class     = $this->modules_namespace . $className;
               $provider  = DNSProviders::where('class',$className)->first();
               if (class_exists($class)) {
                   $object = new $class;
                   if (method_exists($object, $className . "_ConfigOptions"))
                       $configs[] = [$object->{$className . "_ConfigOptions"}(),$className,$provider];
               }


           }catch (\Exception $e)
           {
           }

       }
        $configs = array_reverse($configs);
        return view('dns::providers', compact('pageTitle','pageDescription','breadCrum','configs'));
    }
    public function activateOrDeactivateProvider(Request $request)
    { 
        try {
            $status = $request->input('status',1);
            $msg=$status==1 ? "activated":"deactivated";
            $class   = $request->input('class_name');
            $provider= DNSProviders::where('class',$class);
            if($provider->exists()){
            $provider->update(['status'=>$status]);
            }else{
                DNSProviders::create([
                    'class'=>$class,
                    'status'=>$status
                ]);
            }
            return response()->json(['status' =>true,'message' => "$class provider successfully $msg"]); 
        } catch (\Exception $e) {
           return response()->json(['status' =>false,'message' => $e->getMessage()]); 
        }
        
       
    }

    public function dnsModuleCreate($name)
    {
        /**/
        $page_data = [
            'title' => trans('dns::app.create_module.title'),
            'action' => 'add'
        ];
        $pageTitle = $page_data['title'];
        $pageDescription = trans('dns::app.create_module.pageDesc');
        $breadCrum[] = array('title' => trans('app.lang_integration'), 'url' => "javascript:;");
        $breadCrum[] = array('title' => trans('app.lang_dns_providers'), 'url' => "");
        /**/
        $className = $name;
        $class = $this->modules_namespace . $className;
        $config= [];
        $operations= ['install'=>true,'update' => false];
        if (class_exists($class)) {
            $object = new $class;
            if (method_exists($object, $className . "_ConfigOptions"))
                $config = $object->{$className . "_ConfigOptions"}();
            
        }
        return view('dns::create', compact('page_data','pageTitle','pageDescription','breadCrum','config','operations','className'));
    }

    public function dnsModuleAdd(Request $request)
    {
        $response=Common::verify_license();
        if($response !="success")
            return response()->json(['status' => false,'message' => $response]);
        $redirectTo = null;
        $className = $request->class_name;
        $class = $this->modules_namespace . $className;
        if (!class_exists($class))
        return response()->json(['status' => false,'message' =>
            str_replace(':class',$className,trans('dns::app.create_module.class.not_found'))]);
       else {
            $object = new $class;
            $param = $request->except('_token','btn');
            if (!method_exists($object, $className . "_ConfigOptions"))
                return response()->json(['status' => false,'message' =>
                    str_replace(':method',$className . "_ConfigOptions",trans('dns::app.create_module.method.not_found'))]);
        }
        $message = trans('dns::app.opps.error');
        $created = false;
        $reqFields = $request->except('_token','btn');
        $credentials = $request->except('_token','btn','name','class_name');
        $config = $object->{$className . "_ConfigOptions"}();
        $form = $config['form'];
        $rules = [];
        foreach ($form as $key => $field)
        {

            $type= isset($field['type']) ? $field['type']: null;
            if(!is_null($type))
            {
                $rules[$field['name']] = 'required';
                $rule = $this->determineValidationType($type);
                if(!is_null($rule))
                    $rules[$field['name']] .= '|'.$rule;

            }

        }
        $validator = Validator::make($reqFields,$rules);
        if($validator->fails())
            return response()->json(['status' => 'validation_failed','messages' => $validator->errors()->messages()]);
        $dns = $this->dns->getRecordByWheres([['name','=',$request->name],['user_id','=',authUser()->id]])->first();
       if(!is_null($dns))
           return response()->json(['status' => 'validation_failed','messages' => ['name' => [trans('dns::app.create_module.name_exist')]]]);
        try{
            $req['name'] = $reqFields['name'];
            $req['class_name'] = $className;
            $req['user_id'] = authUser()->id;
            $req['is_deleted'] = 0;
            $req['status'] = isset($reqFields['status']) ? $reqFields['status'] :'inactive';
            $req['auth_data'] = json_encode(Crypt::encrypt($credentials));
            $created = $this->dns->createRecord($req);
            if($created!=false) {
                $created = true;
                $redirectTo = route('dnsModules');
                $status = 'success';
                $message = trans('dns::app.create_module.saved');
            }
        }
        catch (\Exception $e)
        {
           $message = $status = $e->getMessage();
        }
        return response()->json(['status' => $created,'message' => $message,'redirectTo' => $redirectTo]);
    }

    public function dnsModuleEdit($id)
    {
        /**/
        $dns = $this->dns->findByIdOrFail($id);
        $page_data = [
            'title' => trans('dns::app.edit_module.title') ." ".$dns->name,
            'action' => 'add'
        ];
        $pageTitle = $page_data['title'] ;
        $pageDescription = trans('dns::app.edit_module.pageDesc');
        $breadCrum[] = array('title' => trans('app.lang_integration'), 'url' => "javascript:;");
        $breadCrum[] = array('title' => trans('app.lang_dns_providers'), 'url' => "");
        /**/
        $className = $dns->class_name;
        $class = $this->modules_namespace . $className;
        $config= [];
        $operations= ['update'=>true,'install' => false];
        $classExist = class_exists($class);
        if ($classExist) {
            $object = new $class;
            if (method_exists($object, $className . "_ConfigOptions"))
                $config = $object->{$className . "_ConfigOptions"}();
        }
        $auth_data = Crypt::decrypt($dns->auth_data);
        return view('dns::create', compact('dns','page_data','pageTitle','pageDescription','breadCrum','config','operations','className','auth_data'));
    }

    public function dnsModuleUpdate(Request $request,$id)
    {
         $response=Common::verify_license();
        if($response !="success")
            return response()->json(['status' => false,'message' => $response]);
        $className = $request->class_name;
        $class = $this->modules_namespace . $className;
        if (!class_exists($class)) {
           
            return response()->json(['status' => false,'message' =>
                str_replace(':class',$className,trans('dns::app.create_module.class.not_found'))]);
        }
        $message = trans('dns::app.opps.error');
        $updated = false;
        $reqFields = $request->except('_token','btn');
        $credentials = $request->except('_token','btn','name','class_name');
        $keys = array_keys($reqFields);
        $rules = [];
        foreach ($reqFields as $key => $field)
        {

            $type= isset($field['type']) ? $field['type']: null;
            if(!is_null($type))
            {
                $rules[$field['name']] = 'required';
                $rule = $this->determineValidationType($type);
                if(!is_null($rule))
                    $rules[$field['name']] .= '|'.$rule;

            }

        }
       
        $validator = Validator::make($reqFields,$rules);
        if($validator->fails())
            return response()->json(['status' => 'validation_failed','messages' => $validator->errors()->messages()]);
        $dns = $this->dns->getRecordById($id);
        if(is_null($dns))
            return response()->json(['status' => false,'messages' =>trans('dns::app.record.not_found')]);
        if($dns->name!==$request->name) {
            $dns = $this->dns->getRecordByWheres([['name', '=', $request->name], ['user_id', '=', authUser()->id]])->first();
            if (!is_null($dns))
                return response()->json(['status' => 'validation_failed', 'messages' => ['name' => [trans('dns::app.create_module.name_exist')]]]);
        }
        try{
            $req['name'] = $reqFields['name'];
            $req['class_name'] = $className;
            $req['user_id'] = authUser()->id;
            $req['is_deleted'] = 0;
            $req['status'] = isset($reqFields['status']) ? $reqFields['status'] :'inactive';
            $req['auth_data'] = json_encode(Crypt::encrypt($credentials));
            $updated = $this->dns->updateRecord($req,$id);
            if($updated!=false) {
                $created = true;
                $status = 'success';
                $message = trans('dns::app.create_module.saved');
            }
        }
        catch (\Exception $e)
        {
            $message = $status = $e->getMessage();
        }
        
        return response()->json(['status' => $updated,'message' => $message]);
    }

    public function getDnsToDelete(Request $request)
    {
        $id = $request->id;
        $dns = $this->dns->getRecordById($request->id);
        if(is_null($dns))
            return response()->json(['toastr_error' => trans('dns::app.record.not_found')]);
            $method = 'deleteDns('.$id.','.'0)';
            $domain = DNSProvidersAttached::where('dns_id','=',$id)->first();
            if(is_null($domain))
                return response()->json(['method' => $method,'force' => false]);
            $method = 'deleteDns('.$id.','.'1)';
            return response()->json(['method' => $method,'message' => trans('dns::app.module.attachment_error'),'force' => true]);
        
        
    }

    public function dnsModuleDelete(Request $request,$id)
    {
        $dns = $this->dns->getRecordById($id);
        if(is_null($dns)) {
            $message = trans('dns::app.record.not_found');
            return response()->json(['status' => false, 'message' => $message]);
        }
            $deleted       = DNSProvidersAttached::where('dns_id','=',$id)->delete();
            $domain        = AddonDNS::where('id','=',$id)->delete();
            $DNSProviders  = DNSProviders::where('class','=',$dns->class_name)->delete();
            if($deleted)
            $dns->delete();
            return response()->json(['status' => true,'message' => trans('dns::app.module.deleted')]);
        
        $result =  str_replace(':class',$className,trans('dns::app.create_module.class.not_found'));
        return response()->json(['message' =>
            $result]);
    }

    public function activateOrDeactivate(Request $request)
    {
        $message = trans('dns::app.opps.error');
        $dns = $this->dns->getRecordById($request->id);
        if(is_null($dns)) {
            $message = trans('dns::app.record.not_found');
            return response()->json(['status' => false, 'message' => $message]);
        }
        $status = 'active';
        $str = 'Activated';
        if($dns->status == 'active') {
            $status = 'inactive';
            $str = 'Deactivated';
        }
       $updated =  $dns->updateRecord(['status' => $status],$request->id);
        if($updated)
            $message = str_replace(':status',$str,trans('dns::app.status.updated'));
        return response()->json(['status' =>$updated,'message' => $message]);

    }

    private function determineValidationType($type)
    {
        switch ($type)
        {
            case 'email':
                $rule = 'email';
                break;

            case 'number':
                $rule = 'integer';
                break;

            case 'text':
                $rule = 'string';
                break;

            default:
                $rule = null;

        }
        return $rule;
    }

    public function test()
    {
        return 'heloo';
    }
    public function attachProvider(Request $request)
    {
        $domain = DomainMasking::where('id',$request->domain_id)->where('user_id',authUser()->id)->first();
        if(is_null($domain))
            return response()->json(['success' => false,'message' => 'Domain does`nt exist.']);
           $message  = trans('domains.attached.zone');
       if($request->up_fdns)
        {
            $provider  = $request->fdns;
            $zone      = $request->fdns_zone;
            $request->merge(['zone'=> $zone]);
            $validator = Validator::make($request->only('zone','fdns'),['fdns' => 'required','zone' => 'required']);
            if($validator->fails())
                return response()->json(['success' => 'validation_failed','messages' => $validator->errors()->messages()]);
            DNSProvidersAttached::create(['domain_id'=>$request->domain_id,'dns_id' => $provider,'zone' => $zone]);
        }else{
            DNSProvidersAttached::where('domain_id',$request->domain_id)->delete();  
            $message = str_replace('attached to','detached from',$message);
        }
        return response()->json(['success' => true,'message' => $message]);
    }
    public function addDsnRecord(Request $request)
    {
         $response=Common::verify_license();
        if($response !="success")
            return response()->json(['success' => false,'message' => $response]);
        $integration = AddonDNS::find($request->int_id);
        if(!is_null($integration)) {
            $integration = $integration->toArray();
            $provider = $integration['name'];
            $integration['auth_data'] = Crypt::decrypt($integration['auth_data']);

            $class = $integration['class_name'];
                $class_name = $class;
            $class_exists = class_exists($this->dnsNamespace.$class);
            if ($class_exists)
            {
                $class = $this->dnsNamespace.$class;
                $cloud = new $class;
                $method = $class_name."_Update";
                if(!method_exists($cloud,$method))
                    return response()->json(['success' => false,'message' => str_replace(':method',$method,trans('addons.method.not_found'))]);
                $only_host = str_replace(".$request->domain",'',$request->host);
                $integration['host'] = $only_host;
                $integration['type'] = $request->type;
                $integration['domain'] = $request->domain;
                $integration['value'] = $request->value;
                $response = $cloud->{$method}($integration);
                if($response['success']==true)
                    DomainMasking::where('id',$request->domain_id)->update(['is_verified' => 1]);
                $message = $response['message'];
                return response()->json(['success' => $response['success'],'flag' =>$request->flag,'provider'=> $provider,'message' => $message]);
            }
            return response()->json(['success' => false,'message' => str_replace(':class',$class_name,trans('addons.class.not_found'))]);
        }
        return response()->json(['success' => false,'message' => trans('addons.integration.not_found')]);
    }

    public function fetchZones(Request $request) {
        $dns = AddonDNS::find($request->acc_id);
        if(!is_null($dns)) {
            $dnsIntegration = $dns->toArray();
            $dnsIntegration['auth_data'] = Crypt::decrypt($dnsIntegration['auth_data']);
            $class = $this->dnsNamespace . $dns->class_name;
            if (class_exists($class)) {
                $obj = new $class;
                if (!method_exists($obj, $dns->class_name . "_FetchZones"))
                    return response()->json(['success' => false, 'message' => $dns->class_name .'_FetchZones Method does not exist.']);
                $zones = $obj->{$dns->class_name . "_FetchZones"}($dnsIntegration);
                return response()->json($zones);
            }
            return response()->json(['success' => false,'message' => str_replace(':class',$dns->class_name,trans('addons.class.not_found'))]);
        }
        return response()->json(['success' => false,'message' => trans('addons.integration.not_found')]);
    }
    
}