<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

if (!defined("WHMCS")) {
    exit("This file cannot be accessed directly");
}
echo $headeroutput;
if (!project_management_checkperm("View Reports")) {
    echo "<p>You do not have permission to view reports.</p>";
    return false;
}
$pmReportsPath = ["modules", "addons", "project_management", "reports"];
$reports = new WHMCS\File\Directory(implode(DIRECTORY_SEPARATOR, $pmReportsPath));
$reportFiles = $reports->listFiles();
echo "\n<div class=\"pm-addon\">\n    <ul class=\"nav nav-tabs pm-tabs\" role=\"tablist\">\n        <li>\n            <a href=\"addonmodules.php?module=project_management\">\n                <i class=\"fas fa-cube fa-fw\"></i>\n                " . $vars["_lang"]["projects"] . "\n            </a>\n        </li>\n        <li>\n            <a href=\"addonmodules.php?module=project_management&view=tasks\">\n                <i class=\"far fa-check-circle fa-fw\"></i>\n                " . $vars["_lang"]["tasks"] . "\n            </a>\n        </li>\n        <li class=\"active\">\n            <a href=\"addonmodules.php?module=project_management&m=reports\">\n                <i class=\"fas fa-chart-area fa-fw\"></i>\n                " . $vars["_lang"]["viewreports"] . "\n            </a>\n        </li>\n        <li>\n            <a href=\"addonmodules.php?module=project_management&m=activity\">\n                <i class=\"far fa-file-alt fa-fw\"></i>\n                " . $vars["_lang"]["recentactivity"] . "\n            </a>\n        </li>\n    </ul>\n\n    <div class=\"tab-content\">\n        <div role=\"tabpanel\" class=\"tab-pane active\" id=\"home\">\n            <div class=\"project-tab-padding\">\n                ";
$chart = new WHMCS\Chart();
$chartData = ["cols" => [["label" => "Project", "type" => "string"], ["label" => "Completed Tasks", "type" => "number"], ["label" => "Incomplete Tasks", "type" => "number"]], "rows" => []];
$statuses = get_query_val("tbladdonmodules", "value", ["module" => "project_management", "setting" => "completedstatuses"]);
$statuses = explode(",", $statuses);
$result = select_query("mod_project", "id,title", "status NOT IN (" . db_build_in_array($statuses) . ")");
while ($data = mysql_fetch_array($result)) {
    $projectid = $data["id"];
    $title = $data["title"];
    $incompletetasks = get_query_val("mod_projecttasks", "COUNT(id)", ["projectid" => $projectid, "completed" => "0"]);
    $completedtasks = get_query_val("mod_projecttasks", "COUNT(id)", ["projectid" => $projectid, "completed" => "1"]);
    $chartData["rows"][] = ["c" => [["v" => $title], ["v" => $completedtasks, "f" => $completedtasks], ["v" => $incompletetasks, "f" => $incompletetasks]]];
}
$args = ["title" => "Task Status per Project", "legendpos" => "right", "colors" => "#77CC56,#999", "stacked" => true];
echo $chart->drawChart("Column", $chartData, $args, "600px", "100%");
echo "<hr>\n<h2>Available Reports</h2>\n";
foreach ($reportFiles as $reportName) {
    $reportName = str_replace(".php", "", $reportName);
    $displayName = titleCase(str_replace("_", " ", $reportName));
    echo "<a href=\"reports.php?moduletype=addons&modulename=project_management&subdir=reports&report=" . $reportName . "\" target=\"_blank\" class=\"btn btn-default\">" . $displayName . "</a> ";
}
echo "\n            </div>\n        </div>\n    </div>\n</div>";

?>