<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.2 & 7.3
 * @ Decoder version: 1.0.6
 * @ Release: 10/08/2022
 */

define("ADMINAREA", true);
require dirname(__DIR__) . "/init.php";
$aInt = new WHMCS\Admin("Update WHMCS");
$aInt->title = AdminLang::trans("update.title");
$aInt->sidebar = "";
$aInt->helplink = "Automatic Updater";
add_hook("AdminAreaPage", 1, function () {
    return ["minsidebar" => true];
});
$action = App::getFromRequest("action");
Log::pushHandler(WHMCS\Installer\LogServiceProvider::getUpdateLogHandler());
$updater = new WHMCS\Installer\Update\Updater();
$ajaxActions = ["checkforupdates" => ["updateRemoteComposerData"], "save" => ["setConfiguration", ["channel", "temppath", "maintenancemsg"]], "updatefiles" => ["performFileUpdate"]];
if (array_key_exists($action, $ajaxActions)) {
    check_token("WHMCS.admin.default");
    try {
        if (!$aInt->hasAuthConfirmation()) {
            throw new Exception("Authentication has expired. Please refresh the page and try again.");
        }
        $params = [];
        if (isset($ajaxActions[$action][1]) && is_array($ajaxActions[$action][1])) {
            foreach ($ajaxActions[$action][1] as $key) {
                $params[] = App::getFromRequest($key);
            }
        }
        if (App::getFromRequest("licensecheck")) {
            $licensing = DI::make("license");
            $licensing->forceRemoteCheck();
        }
        $response = call_user_func_array([$updater, $ajaxActions[$action][0]], $params);
        $response = array_merge(["success" => true], $response);
    } catch (Exception $e) {
        $response = ["success" => false, "errorMessage" => WHMCS\Input\Sanitize::encode($e->getMessage())];
    }
    $aInt->jsonResponse($response);
} else {
    if ($action == "configure") {
        if (!$aInt->hasAuthConfirmation()) {
            $aInt->jsonResponse(["body" => "Authentication has expired. Please refresh the page and try again."]);
        }
        if (!checkPermission("Modify Update Configuration", true)) {
            $aInt->jsonResponse(["body" => "You do not have permission to access Update Configuration. If you feel this message to be an error, please contact the system administrator."]);
        }
        $updateChannelsOutput = [];
        foreach ($updater->getUpdateChannels() as $channel => $data) {
            $updateChannelsOutput[] = "\n            <div class=\"radio\">\n                <label>\n                    <input type=\"radio\" name=\"channel\" value=\"" . $channel . "\"" . ($channel == $updater->getChannel() ? " checked" : "") . (isset($data["disabled"]) && $data["disabled"] ? " disabled" : "") . ">\n                    <strong>" . $data["displayLabel"] . "</strong> - " . sprintf(isset($data["formatter"]) ? $data["formatter"] : "%s", $data["description"]) . "\n                </label>\n            </div>";
        }
        $body = "\n<form method=\"post\" action=\"\" id=\"frmSaveSettings\">\n    <input type=\"hidden\" name=\"token\" value=\"" . generate_token("plain") . "\">\n    <input type=\"hidden\" name=\"action\" value=\"save\">\n    <div class=\"form-group\">\n        <label for=\"inputUpdateChannel\">Update Channel</label>\n        <p class=\"help-block\">This setting allows you to choose the updates you receive.</p>\n        <div class=\"alert alert-danger hidden\" style=\"padding:5px 10px;\" id=\"invalidChannel\">You must select a valid update channel to continue.</div>\n        <div style=\"margin-left:20px;\">\n            " . implode($updateChannelsOutput) . "\n        </div>\n    </div>\n    <div class=\"form-group\">\n        <label for=\"inputTemporaryPath\">Temporary Path</label>\n        <p class=\"help-block\">The temporary path is used for staging files during an update. It is recommended that this directory be located outside the public doc root.</p>\n        <input type=\"text\" name=\"temppath\" class=\"form-control\" id=\"inputTemporaryPath\" value=\"" . addslashes($updater->getTemporaryPath()) . "\" style=\"margin-bottom:10px\">\n        " . ($updater->isUpdateTempPathConfigured() ? $updater->isUpdateTempPathWriteable() ? "<div class=\"alert alert-success\" style=\"padding:5px 10px;\" id=\"successTempPath\"><strong><i class=\"fas fa-check-circle\"></i> Ok</strong> The temporary path that is set exists and can be written to.</div>" : "<div class=\"alert alert-warning\" style=\"padding:5px 10px;\"><strong><i class=\"fas fa-exclamation-triangle\"></i> Warning</strong> The temporary path that is set currently cannot be written to.</div>" : "<div class=\"alert alert-warning\" style=\"padding:5px 10px;\"><strong><i class=\"fas fa-exclamation-triangle\"></i> Warning</strong> You will not be able to perform an update until a path is set.</div>") . "\n        <div class=\"alert alert-danger hidden\" style=\"padding:5px 10px;\" id=\"invalidTempPath\">The path you entered does not appear to be a valid directory. Please check it and try again.</div>\n        <div class=\"alert alert-danger hidden\" style=\"padding:5px 10px;\" id=\"permissionsTempPath\">The directory path you provided is not writeable. Please check the permissions and try again.</div>\n    </div>\n    <div class=\"form-group\">\n        <label for=\"inputMaintenanceModeMsg\">Maintenance Message</label>\n        <p class=\"help-block\">The message to display to users while an update is in progress.</p>\n        <input type=\"text\" name=\"maintenancemsg\" class=\"form-control\" id=\"inputMaintenanceModeMsg\" value=\"" . addslashes($updater->getMaintenanceMessage()) . "\">\n    </div>\n</form>";
        $aInt->jsonResponse(["body" => $body]);
    }
}
$aInt->requireAuthConfirmation();
$installedVersion = $updater->getVersionParts(App::getVersion());
$latestVersion = $updater->getVersionParts($updater->getLatestVersion());
$isUpdateAvailable = $updater->isUpdateAvailable();
$alerts = $updater->getUpgradeAlerts();
$healthCheck = new WHMCS\View\Admin\HealthCheck\HealthCheckRepository();
$passesHealthCheck = $healthCheck->checkUpdaterRequirements($updater);
$updateNowTooltip = $updateNowDisabled = "";
if (!$updater->isUpdateTempPathConfigured()) {
    $updateNowDisabled = " disabled";
    $updateNowTooltip = " data-toggle=\"tooltip\" data-placement=\"right\" title=\"Update temporary storage path required before you can update. Click to set one now.\"";
} else {
    if ($passesHealthCheck->getSeverityLevel() === Psr\Log\LogLevel::WARNING) {
        $updateNowDisabled = " disabled";
        $updateNowTooltip = " data-toggle=\"tooltip\" data-placement=\"right\" title=\"Unable to update due to environment issues.\"";
    }
}
if (!$isUpdateAvailable) {
    $updateNowDisabled = " disabled";
}
$preUpdateNotifications = [];
if ($isUpdateAvailable) {
    $preUpdateNotifications = $updater->getPreUpdateNotificationsForVersion($updater->getLatestVersion());
}
$preUpdateNotificationsJson = json_encode($preUpdateNotifications);
$updateResourceLinks = "\n<a href=\"" . $updater->getReleaseNotesUrl() . "\" target=\"_blank\" class=\"btn btn-link release-notes-link\" id=\"btnNewReleaseNotes\">Release Notes</a>\n<a href=\"" . $updater->getChangelogUrl() . "\" target=\"_blank\" class=\"btn btn-link change-log-link\" id=\"btnNewChangelog\">Changelog</a>\n";
$content = "\n<div class=\"pull-right\" style=\"margin-top:-40px;\">\n    <a href=\"update.php?action=configure\" class=\"btn btn-default open-modal\" data-modal-title=\"Configure Update Settings\" data-modal-size=\"modal-lg\" data-btn-submit-label=\"Save Changes\" data-modal-class=\"modal-configure-settings\" id=\"btnConfigureUpdateSettings\">\n        <i class=\"fas fa-cog\"></i>\n        Configure Update Settings\n    </a>\n</div>\n\n<div class=\"updater-container\">\n\n<div class=\"alert alert-update-banner\" id=\"preUpdateNotificationTemplate\" style=\"display: none\">\n    <div class=\"alert-icon\">\n        <i class=\"fas fa-fw\"></i>\n    </div>\n\n    <div class=\"alert-msg\">\n        <strong><span data-alert-element=\"alert-title\"></span></strong><br>\n        <span data-alert-element=\"alert-body\"></span>\n\n        <form class=\"form-inline\" data-alert-element=\"checkbox-form\">\n            <input type=\"checkbox\" data-require-acceptance=\"true\" data-alert-element=\"required-checkbox\" class=\"preupdate-require-acceptance-check\">\n            <label data-alert-element=\"required-checkbox-label\"></label>\n        </form>\n    </div>\n</div>\n\n";
$content .= "<div class=\"current-status\">\n    <span id=\"statusUpToDate\" class=\"textgreen" . ($isUpdateAvailable ? " hidden" : "") . "\">\n        <i class=\"far fa-check-circle\"></i>\n        You are running the latest version\n    </span>\n    <span id=\"statusUpdateAvailable\" class=\"textgreen" . ($isUpdateAvailable ? "" : " hidden") . "\">\n        <i class=\"fas fa-info-circle\"></i>\n        An update is available<br />\n    </span>\n</div>\n<div class=\"version-container clearfix\">\n    <div class=\"installed\">" . AdminLang::trans("system.yourversion") . "</div>\n    <div class=\"latest\">" . AdminLang::trans("system.latestversion") . "</div>\n    <div class=\"installed-output\">" . sprintf("<span class=\"version-number\">%s</span><span class=\"version-label\">%s</span><span class=\"version-full\">%s</span>", $installedVersion["number"], $installedVersion["label"], $installedVersion["full"]) . "</div>\n    <div class=\"latest-output\">" . sprintf("<span class=\"version-number\">%s</span><span class=\"version-label\">%s</span><span class=\"version-full\">%s</span>", $latestVersion["number"], $latestVersion["label"], $latestVersion["full"]) . "</div>\n</div>\n<div id=\"preUpdateNotificationContainer\" style=\"display: none\"></div>";
$content .= "\n<div class=\"current-status\">\n        <div style=\"display:inline-block;\"" . $updateNowTooltip . ">\n            <a href=\"#\" class=\"btn btn-default" . $updateNowDisabled . "\" id=\"btnUpdateNow\">\n                Update Now\n            </a>\n        </div>\n        <div>\n            " . $updateResourceLinks . "\n        </div>\n</div>\n\n";
if (!$updater->isUpdateTempPathConfigured()) {
    $content .= "\n<div class=\"alert alert-warning\" id=\"updateTempPathNotConfigured\">\n    <div class=\"alert-icon\">\n        <i class=\"far fa-hand-paper\"></i>\n    </div>\n    <div class=\"alert-msg\">\n        <strong>Warning</strong> You do not currently have a path configured for temporary storage of files during updates. You will not be able to perform an update until one is set. To resolve this now, <a href=\"#\" class=\"alert-link\" id=\"SetTempPath\">click here</a>.\n    </div>\n</div>";
} else {
    if ($passesHealthCheck->getSeverityLevel() === Psr\Log\LogLevel::WARNING) {
        $bodyOutput = $passesHealthCheck->getBody();
        if (substr_count(strtolower($bodyOutput), "<li>") == 1) {
            $bodyOutput = preg_replace("/<\\/?(ul|li)[^<>]*>/i", "", $bodyOutput);
        } else {
            $bodyOutput = "The following environment issue(s) are preventing automatic updates:" . $bodyOutput;
        }
        $content .= "\n<div class=\"alert alert-warning\" id=\"updateEnvironmentIssues\">\n    <div class=\"alert-icon\">\n        <i class=\"fas fa-exclamation-triangle\"></i>\n    </div>\n    <div class=\"alert-msg\">\n        <strong>Unable to Perform Automatic Updates</strong><br>\n        " . $bodyOutput . "\n    </div>\n</div>";
    }
}
$content .= "\n<div class=\"alert alert-update-banner alert-update-banner-warning" . ($alerts["updatesExpired"] || $alerts["updatesBlock"] ? "" : " hidden") . "\" id=\"updateAlertUpdatesBlock\">\n    <div class=\"alert-icon\">\n        <i class=\"fas fa-times\"></i>\n    </div>\n    <div class=\"alert-msg\">\n        <strong>Updates Require New License</strong><br>\n    Access to updates is no longer available for this license. To update, you must purchase a new license key. <a \n    href=\"https://www.whmcs.com/owned-license-upgrade?utm_source=updater&utm_medium=inproduct&utm_campaign=ownedeol\">Learn more</a>\n    </div>\n</div>\n\n<div class=\"alert alert-update-banner alert-update-banner-warning" . (!$alerts["updatesExpired"] && !$alerts["updatesBlock"] && $alerts["pinnedEol"] ? "" : " hidden") . "\" id=\"updateAlertPinnedEol\">\n    <div class=\"alert-icon\">\n        <i class=\"fas fa-times\"></i>\n    </div>\n    <div class=\"alert-msg\">\n        <strong>End of Life Warning</strong><br>\n        The currently installed version has reached End of Life however your current update settings are preventing your installation from being updated. We recommend changing your <a href=\"#\" class=\"set-update-channel alert-link\">update channel</a> to <em>Stable</em> to ensure you are receiving the best possible experience. <a href=\"https://www.whmcs.com/redirect/lts-policy\" target=\"_blank\" class=\"alert-link\">Learn more &raquo;</a>\n    </div>\n</div>\n\n<div class=\"alert alert-update-banner alert-update-banner-info" . (!$alerts["updatesExpired"] && !$alerts["updatesBlock"] && !$alerts["pinnedEol"] && $alerts["pinnedBlock"] ? "" : " hidden") . "\" id=\"updateAlertPinnedBlock\">\n    <div class=\"alert-icon\">\n        <i class=\"fas fa-info-circle\"></i>\n    </div>\n    <div class=\"alert-msg\">\n        <strong>Stable Update Available</strong><br>\n        A newer stable release is available but your current update settings prevent the update from being applied.\n        We recommend changing your <a href=\"#\" class=\"set-update-channel alert-link\">update channel</a> to <em>Stable</em> for the best experience.\n    </div>\n</div>\n\n<div class=\"alert alert-update-banner alert-update-banner-success" . (!$alerts["updatesExpired"] && !$alerts["updatesBlock"] && !$alerts["pinnedEol"] && !$alerts["pinnedBlock"] && $alerts["rcAvailable"] ? "" : " hidden") . "\" id=\"updateAlertRCAvailable\">\n    <div class=\"alert-icon\">\n        <i class=\"fas fa-arrow-up\"></i>\n    </div>\n    <div class=\"alert-msg\">\n        <strong>Release Candidate Update Available</strong><br>\n        A new pre-production release candidate update is available.\n        If you wish to take part in pre-production testing, change your <a href=\"#\" class=\"set-update-channel alert-link\">update channel</a> to <em>Release Candidate</em> to update now.\n    </div>\n</div>\n\n<div class=\"alert alert-update-banner alert-update-banner-grey" . (!$alerts["updatesExpired"] && !$alerts["updatesBlock"] && !$alerts["pinnedEol"] && !$alerts["pinnedBlock"] && !$alerts["rcAvailable"] && $alerts["betaAvailable"] ? "" : " hidden") . "\" id=\"updateAlertBetaAvailable\">\n    <div class=\"alert-icon\">\n        <i class=\"fas fa-arrow-up\"></i>\n    </div>\n    <div class=\"alert-msg\">\n        <strong>Beta Update Available</strong><br>\n        A new pre-production beta update is available.\n        If you wish to take part in beta testing, change your <a href=\"#\" class=\"set-update-channel alert-link\">update channel</a> to <em>Beta</em> to update now.\n        <small><em>(Not recommended for production use)</em></small>\n    </div>\n</div>\n\n<div class=\"check-for-updates\">\n    <p>Last Checked for Updates: <span id=\"labelLastChecked\">" . $updater->getLastCheckedForUpdates() . "</span></p>\n    <button type=\"button\" class=\"btn btn-default\" id=\"btnCheckForUpdates\">\n        <i class=\"fas fa-sync\"></i>\n        Check Now\n    </button>\n</div>\n\n";
$content .= "\n\n</div>\n\n<form method=\"post\" action=\"https://www.whmcs.com/redirect/renew/updates/\" target=\"_blank\" id=\"frmRenewSupportUpdates\">\n    <input type=\"hidden\" name=\"key\" value=\"" . App::get_license_key() . "\" />\n</form>\n";
$csrfToken = generate_token("plain");
$growlError = WHMCS\View\Helper::jsGrowlNotification("error", "", "Unable to fetch latest version. Please try again later.");
$growlNewUpdate = WHMCS\View\Helper::jsGrowlNotification("success", "", "A new update is available!");
$growlNoNewUpdate = WHMCS\View\Helper::jsGrowlNotification("info", "", "No new updates are available.");
$installDirectory = is_dir(ROOTDIR . DIRECTORY_SEPARATOR . "install2") ? "install2" : "install";
$updaterErrorText = AdminLang::trans("updater.failure");
$jquerycode = "\$('#btnUpdateNow').parent('div').click(function(e) {\n    \$('a#SetTempPath').click();\n});\n\n\$('#btnUpdateNow').click(function(e) {\n    e.preventDefault();\n    var acceptanceMissing = false;\n    jQuery('[data-alert-element=\"required-checkbox\"]:visible').each(\n        function(index, element) {\n            if (!element.checked) {\n                swal({\n                    title: \"Confirmation Required\",\n                    text: \"Please check the checkbox(s) to confirm you have read and understand all of the pre-update notifications to continue with the update process.\",\n                    icon: \"error\"\n                });\n                acceptanceMissing = true;\n                return false;\n            }\n        }\n    );\n\n    if (!acceptanceMissing) {\n        openModal('updatesteps.php?version=' + \$('.latest-output').find('.version-full').html(), '', 'Auto Update', 'modal-lg', 'modal-update-steps', 'Continue');\n    }\n});\n\n\$('.support-and-updates-refresh').click(function(e) {\n    e.preventDefault();\n    \$('.support-and-updates-refresh').prop('disabled', true).find('i').addClass('fa-spin');\n    \$('#btnCheckForUpdates').trigger('click', [1]);\n});\n\nfunction showPreUpdateNotifications(notifications, allowAnimation)\n{\n    var preUpdateNotificationContainer = \$('#preUpdateNotificationContainer');\n    var preUpdateNotificationTemplate = \$('#preUpdateNotificationTemplate');\n\n    var idsToShow = [];\n    var idsToHide = [];\n\n    for (var index=0;index<notifications.length;index++) {\n        var message = notifications[index];\n\n        idsToShow.push(message.id);\n\n        if (\$('[data-message-id=\"' + message.id + '\"]').length > 0) {\n            continue;\n        }\n\n        var notificationElement = \$(preUpdateNotificationTemplate).clone();\n\n        \$(notificationElement).attr('id', 'preUpdateNotification-' + message.id)\n        \$(notificationElement).attr('data-message-id', message.id)\n\n        \$(notificationElement).find('.alert-icon i.far').addClass(message.icon);\n        \$(notificationElement).find('[data-alert-element=\"alert-title\"]').html(message.title);\n        \$(notificationElement).find('[data-alert-element=\"alert-body\"]').html(message.body.replace(\"\\n\", '<br>'));\n\n        var checkboxForm = \$(notificationElement).find('[data-alert-element=\"checkbox-form\"]');\n\n        if (message.requireAcceptance) {\n            var checkboxId = 'preUpdateNotificationAcceptCheckbox-' + message.id;\n\n            \$(checkboxForm).find('[data-alert-element=\"required-checkbox\"]').attr('id', checkboxId);\n\n            \$(checkboxForm)\n                .find('[data-alert-element=\"required-checkbox-label\"]')\n                .attr('for', checkboxId)\n                .html(message.requireAcceptance);\n        } else {\n            \$(checkboxForm).hide();\n        }\n\n        \$(notificationElement).addClass('alert-update-banner-' + message.style);\n\n        \$(preUpdateNotificationContainer).append(notificationElement);\n    }\n\n    \$(preUpdateNotificationContainer).find('.alert-update-banner:visible').each(function() {\n        var notificationElement = this;\n        var notificationElementMessageId = \$(notificationElement).attr('data-message-id');\n\n        if (idsToShow.indexOf(notificationElementMessageId) === -1) {\n            idsToHide.push(notificationElementMessageId);\n        }\n    });\n\n    for (index=0;index<idsToHide.length;index++) {\n        notificationElement = \$('[data-message-id=\"' + idsToHide[index] + '\"]');\n\n        if (allowAnimation) {\n            \$(notificationElement).slideUp();\n        } else {\n            \$(notificationElement).hide();\n        }\n    }\n\n    for (index=0;index<idsToShow.length;index++) {\n        notificationElement = \$('[data-message-id=\"' + idsToShow[index] + '\"]');\n\n        if (allowAnimation && \$(preUpdateNotificationContainer).is(':visible')) {\n            // do not try to animate both messages and their container if its hidden\n            \$(notificationElement).slideDown();\n        } else {\n            \$(notificationElement).show();\n        }\n    }\n\n    if (idsToShow.length > 0) {\n        if (allowAnimation) {\n            \$(preUpdateNotificationContainer).slideDown();\n        } else {\n            \$(preUpdateNotificationContainer).show();\n        }\n    }\n}\n\n\$('#btnCheckForUpdates').click(function(e, withLicenseCheck) {\n    if (typeof withLicenseCheck != 'undefined') {\n        withLicenseCheck = '&licensecheck=1';\n    } else {\n        withLicenseCheck = '';\n    }\n    \$(this).prop('disabled', true).find('i').addClass('fa-spin');\n    WHMCS.http.jqClient.post('update.php', 'action=checkforupdates&token=" . $csrfToken . "' + withLicenseCheck, function(data) {\n        if (data.success) {\n            \$('.latest-output .version-number').html(data.latestVersion.number);\n            \$('.latest-output .version-label').html(data.latestVersion.label);\n            \$('.latest-output .version-full').html(data.latestVersion.full);\n            \$('.release-notes-link').attr('href', data.releaseNotesUrl);\n            \$('.template-changes-link').attr('href', data.releaseNotesUrl + '#Template_Changes');\n            \$('.change-log-link').attr('href', data.changelogUrl);\n            if (data.canUpdate) {\n                \$('#statusUpToDate').hide();\n                \$('#statusUpdateAvailable').removeClass('hidden').show();\n                \$('#btnUpdateNow').removeClass('disabled');\n                " . $growlNewUpdate . "\n            } else {\n                \$('#statusUpToDate').removeClass('hidden').show();\n                \$('#statusUpdateAvailable').hide();\n                \$('#btnUpdateNow').addClass('disabled');\n                " . $growlNoNewUpdate . "\n            }\n            \$('#labelLastChecked').html('Just now');\n            if (data.alerts.updatesBlock || data.alerts.updatesExpired) {\n                if (!\$('#updateAlertUpdatesBlock').is(':visible')) {\n                    \$('.alert-update-banner').hide();\n                    \$('#updateAlertUpdatesBlock').hide().removeClass('hidden').fadeIn();\n                }\n            } else if (data.alerts.pinnedEol) {\n                if (!\$('#updateAlertPinnedEol').is(':visible')) {\n                    \$('.alert-update-banner').hide();\n                    \$('#updateAlertPinnedEol').hide().removeClass('hidden').fadeIn();\n                }\n            } else if (data.alerts.pinnedBlock) {\n                if (!\$('#updateAlertPinnedBlock').is(':visible')) {\n                    \$('.alert-update-banner').hide();\n                    \$('#updateAlertPinnedBlock').hide().removeClass('hidden').fadeIn();\n                }\n            } else if (data.alerts.rcAvailable) {\n                if (!\$('#updateAlertRCAvailable').is(':visible')) {\n                    \$('.alert-update-banner').hide();\n                    \$('#updateAlertRCAvailable').hide().removeClass('hidden').fadeIn();\n                }\n            } else if (data.alerts.betaAvailable) {\n                if (!\$('#updateAlertBetaAvailable').is(':visible')) {\n                    \$('.alert-update-banner').hide();\n                    \$('#updateAlertBetaAvailable').hide().removeClass('hidden').fadeIn();\n                }\n            } else {\n                \$('.alert-update-banner').fadeOut();\n            }\n\n            if (data.notifications) {\n                showPreUpdateNotifications(data.notifications, true);\n            }\n\n        } else {\n            // an error occurred\n            jQuery.growl.error({ title: \"\", message: data.errorMessage });\n        }\n        \$('#btnCheckForUpdates').removeProp('disabled').find('i').removeClass('fa-spin');\n        \$('.support-and-updates-refresh').removeProp('disabled').find('i').removeClass('fa-spin');\n    });\n});\n\n\$('body').on('click', '.modal-update-steps .btn-primary', function(e) {\n    var oncePerClick = false;\n    var currentStep = \$('.update-steps div:visible');\n    var nextStep = currentStep.next('div');\n    if (!nextStep.length) {\n        \$('#modalAjax').modal('hide');\n        return;\n    }\n    currentStep.fadeOut('', function() {\n        \$('#updateStallWarning').hide(0); // Instantly hide the stall warning.\n        nextStep.fadeIn('', function() {\n            if (oncePerClick) {\n                return;\n            }\n            if (\$('.update-steps div:visible').find('input[name=\"step\"]').val() == 'update') {\n                // Alert the admin that something went wrong if we're still waiting on the post after 90 seconds.\n                var stallWarning = setTimeout(function() {\n                    \$('#updateNavigationWarning').fadeOut(400, function () {\n                        \$('#updateStallWarning').fadeIn();\n                    })\n                }, 90000);\n                WHMCS.http.jqClient.post('update.php', 'action=updatefiles&token=" . $csrfToken . "', function(data) {\n                    clearTimeout(stallWarning);\n                    if (data.success) {\n                        if (data.updateSuccessful) {\n                            \$('.release-notes-link').attr('href', data.releaseNotesUrl);\n                            \$('.template-changes-link').attr('href', data.releaseNotesUrl + '#Template_Changes');\n                            WHMCS.http.jqClient.post('../" . $installDirectory . "/update.php', 'token=' + \$('#updaterUpdateToken').val(), function(data) {\n                                if (data.success) {\n                                    \$('.installed-output').html(\$('.latest-output').html());\n                                    \$('#statusUpdateAvailable').hide();\n                                    \$('#statusUpToDate').removeClass('hidden').show();\n                                    \$('a.update-now').fadeOut();\n                                    \$('.update-result-failed').remove();\n                                } else {\n                                    if (data.errorMessage) {\n                                        \$('.update-failure-output').html(data.errorMessage);\n                                    }\n                                    \$('.update-result-successful').hide();\n                                }\n                                \$('#modalAjax .btn-primary').removeProp('disabled').click().prop('disabled', true);\n                            }, 'json');\n                        } else {\n                            if (data.errorMessage) {\n                                \$('.update-failure-output').html(data.errorMessage);\n                            } else if (data.debugOutput) {\n                                \$('.update-failure-output').html(data.debugOutput);\n                            }\n                            \$('.update-result-successful').hide();\n                            \$('#modalAjax .btn-primary').removeProp('disabled').click().prop('disabled', true);\n                        }\n                    } else {\n                        if (data.errorMessage) {\n                            \$('.update-failure-output').html(data.errorMessage);\n                        }\n                        \$('.update-result-successful').hide();\n                        \$('#modalAjax .btn-primary').removeProp('disabled').click().prop('disabled', true);\n                    }\n                }, 'json').fail(function () {\n                    // There was an error.\n                    \$('.update-result-successful').hide();\n                    \$('.update-failure-output').html('<p>" . $updaterErrorText . "</p>');\n                    \$('#modalAjax .btn-primary').removeProp('disabled').click().prop('disabled', true);\n                });\n            }\n            oncePerClick = true;\n        });\n        var stepName = nextStep.find('input[name=\"step\"]').val();\n        if (stepName == 'preflight') {\n            \$('#modalAjax .btn-primary').html('Begin Update');\n        } else if (stepName == 'update') {\n            \$('#modalAjax').data('bs.modal').options.backdrop = 'static';\n            \$('#modalAjax').data('bs.modal').options.keyboard = false;\n            \$('#modalAjax').off('keyup.dismiss.bs.modal');\n            \$('.modal-backdrop.in').addClass('updater-modal-backdrop');\n            \$('#modalAjax .close').hide();\n            \$('#modalAjax .btn-primary').prop('disabled', true).html('Please Wait...');\n        } else if (stepName == 'finish') {\n            \$('#modalAjax .btn-primary').removeProp('disabled').html('Finish');\n        }\n    });\n});\n\n\$('body').on('click', '.modal-configure-settings .btn-primary', function(e) {\n    var el = \$('.modal-submit');\n    var btnLabel = el.html();\n    el.prop('disabled', true).css('width', el.css('width')).html('<i class=\"fas fa-spinner fa-spin\"></i>');\n    var postdata = jQuery('#modalAjax').find('form').serialize();\n\n    var save = WHMCS.http.jqClient.post('update.php', postdata);\n\n    save.done(function(data) {\n        el.removeProp('disabled').html(btnLabel);\n\n        error = false;\n\n        if (data.invalidChannel) {\n            \$('#invalidChannel').removeClass('hidden').show();\n            error = true;\n        } else {\n            \$('#invalidChannel').hide();\n        }\n\n        if (data.invalidPath) {\n            \$('#inputTemporaryPath').parent('.form-group').addClass('has-error');\n            \$('#invalidTempPath').removeClass('hidden').show();\n            \$('#successTempPath').hide();\n            error = true;\n        } else {\n            \$('#inputTemporaryPath').parent('.form-group').removeClass('has-error');\n            \$('#invalidTempPath').hide();\n        }\n\n        if (data.pathNotWriteable) {\n            \$('#inputTemporaryPath').parent('.form-group').addClass('has-error');\n            \$('#permissionsTempPath').removeClass('hidden').show();\n            \$('#successTempPath').hide();\n            error = true;\n        } else {\n            \$('#inputTemporaryPath').parent('.form-group').removeClass('has-error');\n            \$('#permissionsTempPath').hide();\n        }\n\n        if (!error) {\n            \$('#updateTempPathNotConfigured').hide();\n            \$('#btnUpdateNow').removeClass('disabled').parent('div').tooltip('destroy').unbind('click');\n            \$('#modalAjax').modal('hide');\n            if (data.channelChanged) {\n                \$('#btnCheckForUpdates').click();\n            }\n        }\n    });\n});\n\n\$('a#SetTempPath').click(function(e) {\n    e.preventDefault();\n    \$('#btnConfigureUpdateSettings').click();\n    \$('#inputTemporaryPath').focus();\n});\n\n\$('body').on('click', '.set-update-channel', function(e) {\n    e.preventDefault();\n    \$('#btnConfigureUpdateSettings').click();\n});\n\n\$('body').on('click', '.renew-support-updates', function(e) {\n    e.preventDefault();\n    \$('#frmRenewSupportUpdates').submit();\n});\n\n\$('#modalAjax').on('show.bs.modal', function () {\n    \$('#modalAjax .btn-primary').removeProp('disabled');\n    if (\$(this).hasClass('modal-update-steps')) {\n        \$('#modalAjax .panel-default').removeClass('panel-default').addClass('panel-primary');\n        \$('#modalAjaxClose').hide();\n    } else {\n        \$('#modalAjax .panel-primary').removeClass('panel-primary').addClass('panel-default');\n    }\n});\n\$('#modalAjax').on('hidden.bs.modal', function () {\n    \$('#modalAjaxClose').show();\n    \$('#modalAjax').data('bs.modal').options.backdrop = '1';\n    \$('#modalAjax').data('bs.modal').options.keyboard = true;\n    \$('#modalAjax .close').show();\n    \$('#modalAjax').removeClass('modal-configure-settings').removeClass('modal-update-steps');\n});\n\nvar preUpdateNotifications = " . $preUpdateNotificationsJson . ";\n\nshowPreUpdateNotifications(preUpdateNotifications, false);\n";
$aInt->content = $content;
$aInt->jquerycode = $jquerycode;
$aInt->display();

?>